; VRoidポーズ変更＋状態記録用マクロ

; pose + emo 両方
[macro name="vroid_pose_set"]
[iscript]
var id = mp.id || sf.model_id;
var pose = mp.pose || sf["pose_" + id] || "pose1001";
var emo = mp.emo || sf["emo_" + id] || "default";
var time = mp.time || 1000;

sf.model_id = id;
sf["pose_" + id] = pose;
sf["emo_" + id] = emo;
sf["time_" + id] = time;

// テンポラリ変数に格納（展開エラー防止）
sf.tmp_pose = pose;
sf.tmp_emo = emo;
sf.tmp_time = time;
[endscript]

[VRoid_pose modelID=&sf.model_id pose=&sf.tmp_pose emo=&sf.tmp_emo time=&sf.tmp_time]
[endmacro]



; emo のみ
[macro name="vroid_emo_set"]
[iscript]
var id = mp.id || sf.model_id;
var emo = mp.emo || sf["emo_" + id] || "default";

sf.model_id = id;
sf["emo_" + id] = emo;

// 展開用一時変数
sf.tmp_emo = emo;
[endscript]

[VRoid_emo modelID=&sf.model_id name=&sf.tmp_emo]
[endmacro]



; pose のみ
[macro name="vroid_pose_only_set"]
[iscript]
var id = mp.id || sf.model_id;
var pose = mp.pose || sf["pose_" + id] || "pose1001";

sf.model_id = id;
sf["pose_" + id] = pose;

// 一時展開変数
sf.tmp_pose = pose;
[endscript]

[VRoid_pose modelID=&sf.model_id pose=&sf.tmp_pose]
[endmacro]

; VRoidモデルの位置・回転を記録して動かすマクロ（ポーズと表情も再適用）
[macro name="vroid_model_move_set"]
[iscript]
var id = mp.id || sf.model_id;
var rotY = mp.rotY || 0;
var easing = mp.easing || "easeOutBack";
var time = mp.time || 1500;

sf.model_id = id;
sf["rotY_" + id] = rotY;
sf["easing_" + id] = easing;
sf["time_" + id] = time;

// 展開用テンポラリ変数
sf.tmp_rotY = rotY;
sf.tmp_easing = easing;
sf.tmp_time = time;
sf.tmp_pose = sf["pose_" + id] || "pose1001";
sf.tmp_emo = sf["emo_" + id] || "default";
[endscript]

[VRoid_model_move modelID=&sf.model_id rotY=&sf.tmp_rotY easing=&sf.tmp_easing time=&sf.tmp_time]

; 再適用（move後に表情ポーズがリセットされる環境に対応）
[VRoid_pose modelID=&sf.model_id pose=&sf.tmp_pose emo=&sf.tmp_emo time=&sf.tmp_time]
[endmacro]

; --- 辞書データ登録マクロ ---

; --- 挨拶パターン登録（小分け版） ---
[macro name="set_aisatsu_patterns"]
[eval exp="tyrano.plugin.kag.tmp_patterns=[];"]

[eval exp="tyrano.plugin.kag.tmp_patterns.push({word:'覚えて',replies:['あ、うん。何も覚えてないみたい','そうだね。困ったな','うん。何も思い出せない。……心配してくれてるの？'],feeling:'relieved'});"]
[eval exp="tyrano.plugin.kag.tmp_patterns.push({word:'記憶',replies:['うん。記憶……ないみたいだね','うん。そうみたい。心配してくれてるの？','うん。何も思い出せないみたい'],feeling:'relieved'});"]
[eval exp="tyrano.plugin.kag.tmp_patterns.push({word:'気分は',replies:['あ、うん。悪くはないかな。ありがとう','うん。悪くないよ。','え？　うん。大丈夫。ありがとう'],feeling:'relieved'});"]
[eval exp="tyrano.plugin.kag.tmp_patterns.push({word:'おはよ',replies:['おはよう！','おはよう。','おはよー！'],feeling:'positive'});"]
[eval exp="tyrano.plugin.kag.tmp_patterns.push({word:'こんにち',replies:['こんにちは！','やあ、こんにちは！','こんにちは。'],feeling:'positive'});"]
[eval exp="tyrano.plugin.kag.tmp_patterns.push({word:'こんばん',replies:['こんばんは！','こんばんは。今は夜なんだね。'],feeling:'positive'});"]
[eval exp="tyrano.plugin.kag.tmp_patterns.push({word:'大丈夫',replies:['うん……たぶん。','大丈夫……って言っていいのかな'],feeling:'relieved'});"]
[eval exp="tyrano.plugin.kag.tmp_patterns.push({word:'だいじょうぶ',replies:['うん……たぶん。','大丈夫……って言っていいのかな。でも声をかけてくれてうれしい。'],feeling:'relieved'});"]
[eval exp="tyrano.plugin.kag.tmp_patterns.push({word:'誰',replies:['わたし……誰なんだろう……','誰？　わたし……誰なんだろう……記憶がなくて……ごめんね。'],feeling:'sad'});"]
[eval exp="tyrano.plugin.kag.tmp_patterns.push({word:'だれ',replies:['わたし……誰なんだろう……','記憶がなくて……ごめんね。'],feeling:'sad'});"]
[eval exp="tyrano.plugin.kag.tmp_patterns.push({word:'どうした',replies:['気がついたらここにいたの……','何も覚えてないの……。'],feeling:'sad'});"]
[eval exp="tyrano.plugin.kag.tmp_patterns.push({word:'こわい',replies:['ちょっと怖いけど、大丈夫……','怖いのは怖いよ。でも大丈夫'],feeling:'relieved'});"]
[eval exp="tyrano.plugin.kag.tmp_patterns.push({word:'怖い',replies:['ちょっと怖いけど、大丈夫……','怖いのは怖いよ。でも大丈夫'],feeling:'relieved'});"]
[eval exp="tyrano.plugin.kag.tmp_patterns.push({word:'怖くない',replies:['ちょっと怖いけど、大丈夫……','怖いのは怖いよ。でも大丈夫'],feeling:'relieved'});"]
[eval exp="tyrano.plugin.kag.tmp_patterns.push({word:'元気',replies:['……元気……じゃない、かも。','ちょっと混乱してる……。'],feeling:'neutral'});"]
[eval exp="tyrano.plugin.kag.tmp_patterns.push({word:'名前',replies:['……思い出せないの、ごめん……','わたしの名前……思い出せないの。'],feeling:'sad'});"]
[eval exp="tyrano.plugin.kag.tmp_patterns.push({word:'落ち着いて',replies:['ありがとう、少し落ち着いたよ。','やさしい言葉、嬉しいな。'],feeling:'relieved'});"]
[eval exp="tyrano.plugin.kag.tmp_patterns.push({word:'ここはどこ',replies:['ここ、知らない場所……。','どこか閉ざされた部屋みたい。'],feeling:'neutral'});"]
[eval exp="tyrano.plugin.kag.tmp_patterns.push({word:'何が見える',replies:['白い壁とベッドだけ……。','人気のない寂しい部屋だよ。'],feeling:'sad'});"]
[eval exp="tyrano.plugin.kag.tmp_patterns.push({word:'かわいい',replies:['……急に何言うの？　怖いよ'],feeling:'sad'});"]
[eval exp="tyrano.plugin.kag.tmp_patterns.push({word:'目が覚めた',replies:['あ。うん。おはよう。おはようって言っていいのかな？　今が何時なのか分からないけど……'],feeling:'sad'});"]

[eval exp="sf.patterns=tyrano.plugin.kag.tmp_patterns;"]
[endmacro]


; --- 名前パターン登録（直接プレイヤー名を挿入する版） ---
[macro name="set_name_patterns"]
[eval exp="sf.patterns_namae=[{word:'俺は', replies:['うん、PLAYER_NAMEだね。……初めて聞いた名前。','PLAYER_NAMEっていうんだね、覚えるよ。'], feeling:'positive'},{word:'私は', replies:['うん、PLAYER_NAMEだね。覚えたよ','素敵な名前だね、PLAYER_NAME。'], feeling:'positive'},{word:'僕は', replies:['PLAYER_NAME……。ありがとう、教えてくれて。','うん、PLAYER_NAME。安心できる気がする。'], feeling:'positive'},{word:'名前は', replies:['PLAYER_NAMEって言うんだね。覚えたよ。','教えてくれてありがとう、PLAYER_NAME。'], feeling:'positive'},{word:'という', replies:['PLAYER_NAME……いい名前だね。','PLAYER_NAMEって呼んでいい？'], feeling:'positive'},{word:'うちは', replies:['PLAYER_NAMEっていうのか。かわいい名前だね。','うちは……って面白い言い方だね、PLAYER_NAME。'], feeling:'positive'},{word:'って言う', replies:['PLAYER_NAMEって言うんだね。覚えるよ。','そうなんだ、PLAYER_NAMEって呼ぶね。'], feeling:'positive'},{word:'', replies:['PLAYER_NAME…うん、いい名前だね。覚えたよ。'], feeling:'positive'}];"]
[endmacro]


; --- 挨拶会話マッチングマクロ（挨拶・会話用・1行版） ---
[macro name="match_patterns"]
[eval exp="sf.matched=false;var patterns=sf.patterns;for(var i=0;i<patterns.length;i++){if(sf.input.indexOf(patterns[i].word)!=-1){var replies=patterns[i].replies;var index=Math.floor(Math.random()*replies.length);sf.reply=replies[index];sf.feeling=patterns[i].feeling;sf.matched=true;if(sf.feeling=='positive'||sf.feeling=='relieved'){sf.shinmitsudo+=1;}if(sf.feeling=='sad'){sf.shinmitsudo-=1;}break;}}"]
[endmacro]

; --- 名前マッチングマクロ（完全拡張版）教えない追加 ---
[macro name="match_name_patterns"]
[eval exp="sf.matched=false;var ngwords=['教えない','秘密','ひみつ','やだ','無理','答えたくない','言わない','内緒','教えたくない','言えない','言いたくない','嫌だ','いや','いやだ','ナイショ','内緒だよ','まだ言えない','必要ない','どうでもいい','特別なものじゃない','名乗るほどの者じゃない','言わない主義','詮索禁止','教えたら面白くないじゃん','教えたら消えちゃうかも','そんなもの必要ない','今は名無しでいいよ','通りすがり','流れ者','気分次第','気にしないで','ミステリアスってことで','謎','秘密のまま','ひみつ主義','それはナイショ','教えないって決めた','聞かないで','ノーコメント','まだ秘密にしておく','まだ内緒','それは後で','後で教えるかも','今は秘密','そっとしておいて','教えたら世界が終わる','名無し界の覇者','存在がオフレコ','国家機密','重要機密につき非公開','セキュリティレベル高すぎて開示不可','開発中','未実装','プロトタイプなので未登録','影のもの','呼び名をまだ設定してない'];var patterns=sf.patterns_namae;var name_part=sf.input.replace(/(だ|だよ|だね|です|なの|だな)$/,'').trim();var is_ng=false;for(var j=0;j<ngwords.length;j++){if(name_part.indexOf(ngwords[j])!=-1){is_ng=true;break;}}sf.player_name=name_part;if(name_part==='天音亜音'){sf.reply='……どこかで聞いたことがある気がする。どこか落ち着く良い名前だね。';sf.feeling='relieved';sf.matched=true;sf.shinmitsudo+=6;}else if(name_part==='無為澪'){sf.reply='……無為澪？　あああ！！　頭が痛い！　それ本当に君の名前？　信じるけど……';sf.feeling='sad';sf.matched=true;sf.shinmitsudo-=5;}else if(name_part==='天音'){sf.reply='天音……懐かしい響き。でも、どこで聞いたんだろう。';sf.feeling='relieved';sf.matched=true;sf.shinmitsudo+=2;}else if(name_part==='亜音'){sf.reply='亜音……懐かしい響き。でも、どこで聞いたんだろう。';sf.feeling='relieved';sf.matched=true;sf.shinmitsudo+=2;}else if(name_part==='無為'){sf.reply='無為……？　あああ！！　頭が痛い！　それ本当に君の名前？　信じるけど……';sf.feeling='sad';sf.matched=true;sf.shinmitsudo-=5;}else if(name_part==='澪'){sf.reply='澪……？　あああ！！　頭が痛い！　それ本当に君の名前？　信じるけど……';sf.feeling='sad';sf.matched=true;sf.shinmitsudo-=5;}if(!sf.matched){for(var i=0;i<patterns.length;i++){if(sf.input.indexOf(patterns[i].word)!=-1){name_part=sf.input.replace(patterns[i].word,'');name_part=name_part.replace(/(だ|だよ|だね|です|なの|だな)$/,'').trim();sf.player_name = name_part;if(name_part==='天音亜音'){sf.reply='……どこかで聞いたことがある気がする。どこか落ち着く良い名前だね。';sf.feeling='relieved';sf.matched=true;sf.shinmitsudo+=6;break;}else if(name_part==='無為澪'){sf.reply='……無為澪？　あああ！！　頭が痛い！　それ本当に君の名前？　信じるけど……';sf.feeling='sad';sf.matched=true;sf.shinmitsudo-=5;break;}else if(name_part==='天音'){sf.reply='天音……懐かしい響き。でも、どこで聞いたんだろう。';sf.feeling='relieved';sf.matched=true;sf.shinmitsudo+=2;break;}else if(name_part==='亜音'){sf.reply='亜音……懐かしい響き。でも、どこで聞いたんだろう。';sf.feeling='relieved';sf.matched=true;sf.shinmitsudo+=2;break;}else if(name_part==='無為'){sf.reply='無為……？　あああ！！　頭が痛い！　それ本当に君の名前？　信じるけど……';sf.feeling='sad';sf.matched=true;sf.shinmitsudo-=5;break;}else if(name_part==='澪'){sf.reply='澪……？　あああ！！　頭が痛い！　それ本当に君の名前？　信じるけど……';sf.feeling='sad';sf.matched=true;sf.shinmitsudo-=5;break;}if(name_part==''){name_part='君';}sf.player_name=name_part;var replies=patterns[i].replies;var index=Math.floor(Math.random()*replies.length);sf.reply=replies[index];sf.feeling=patterns[i].feeling;sf.matched=true;if(sf.feeling=='positive'||sf.feeling=='relieved'){sf.shinmitsudo+=1;}break;}}}if(!sf.matched){if(name_part==''||is_ng){sf.reply='そっか……教えてくれないんだね……。';sf.feeling='sad';sf.matched=true;sf.shinmitsudo-=1;}else{sf.reply='PLAYER_NAME…うん、いい名前だね。覚えたよ。';sf.feeling='positive';sf.matched=true;sf.shinmitsudo+=1;}}"]
[endmacro]

; --- 私を知っている/知らないパターン登録 ---
[macro name="set_sitteiru_patterns"]
[eval exp="tyrano.plugin.kag.tmp_patterns_shitteiru=[];"]
[eval exp="tyrano.plugin.kag.tmp_patterns_shitteiru.push({word:'知って', replies:['なら、教えて？　私はいったい誰？'], feeling:'neutral', result:'know'});"]
[eval exp="tyrano.plugin.kag.tmp_patterns_shitteiru.push({word:'もちろん', replies:['なら、教えて？　私はいったい誰？'], feeling:'neutral', result:'know'});"]
[eval exp="tyrano.plugin.kag.tmp_patterns_shitteiru.push({word:'知らな', replies:['そっか。それじゃあしょうがないね'], feeling:'anxiety', result:'dont_know'});"]
[eval exp="tyrano.plugin.kag.tmp_patterns_shitteiru.push({word:'分から', replies:['そっか。それじゃあしょうがないね'], feeling:'anxiety', result:'dont_know'});"]
[eval exp="sf.patterns_shitteiru=tyrano.plugin.kag.tmp_patterns_shitteiru;"]
[endmacro]


; --- 知ってる/知らないマッチングマクロ ---
[macro name="match_shitteiru_patterns"]
[eval exp="sf.matched=false;var patterns=sf.patterns_shitteiru;for(var i=0;i<patterns.length;i++){if(sf.input.indexOf(patterns[i].word)!=-1){var replies=patterns[i].replies;var index=Math.floor(Math.random()*replies.length);sf.reply=replies[index];sf.result=patterns[i].result;sf.matched=true;break;}}"]
[endmacro]

; --- 君の名前はパターン登録 ---
[macro name="set_kiminonamae_patterns"]
[eval exp="tyrano.plugin.kag.tmp_patterns=[];"]

[eval exp="tyrano.plugin.kag.tmp_patterns.push({word:'天音',replies:['天音……そうだ。私の名前は……天音亜音……だ','天音？　……うん。何かしっくりくる。そうだ。私は天音亜音だ。','……思い出した。そう。私の名前は天音亜音だった'],feeling:'relieved',result:'amane'});"]
[eval exp="tyrano.plugin.kag.tmp_patterns.push({word:'亜音',replies:['天音……そうだ。私の名前は……天音亜音……だ','天音？　……うん。何かしっくりくる。そうだ。私は天音亜音だ。','……思い出した。そう。私の名前は天音亜音だった'],feeling:'relieved',result:'amane'});"]
[eval exp="tyrano.plugin.kag.tmp_patterns.push({word:'天音亜音',replies:['天音……そうだ。私の名前は……天音亜音……だ','天音？　……うん。何かしっくりくる。そうだ。私は天音亜音だ。','……思い出した。そう。私の名前は天音亜音だった'],feeling:'relieved',result:'amane'});"]
[eval exp="tyrano.plugin.kag.tmp_patterns.push({word:'あまね',replies:['天音……そうだ。私の名前は……天音亜音……だ','天音？　……うん。何かしっくりくる。そうだ。私は天音亜音だ。','……思い出した。そう。私の名前は天音亜音だった'],feeling:'relieved',result:'amane'});"]
[eval exp="tyrano.plugin.kag.tmp_patterns.push({word:'あおん',replies:['天音……そうだ。私の名前は……天音亜音……だ','天音？　……うん。何かしっくりくる。そうだ。私は天音亜音だ。','……思い出した。そう。私の名前は天音亜音だった'],feeling:'relieved',result:'amane'});"]
[eval exp="tyrano.plugin.kag.tmp_patterns.push({word:'無為',replies:['……無為……無為……','無為……澪？　私が……？','……え？　何を言っているの？　違う……私は……'],feeling:'sad',result:'kagenasi'});"]
[eval exp="tyrano.plugin.kag.tmp_patterns.push({word:'澪',replies:['……無為……無為……','無為……澪？　私が……？','……え？　何を言っているの？　違う……私は……'],feeling:'sad',result:'kagenasi'});"]
[eval exp="tyrano.plugin.kag.tmp_patterns.push({word:'無為澪',replies:['……無為……無為……','無為……澪？　私が……？','……え？　何を言っているの？　違う……私は……'],feeling:'sad',result:'kagenasi'});"]
[eval exp="tyrano.plugin.kag.tmp_patterns.push({word:'かげなし',replies:['……無為……無為……','無為……澪？　私が……？','……え？　何を言っているの？　違う……私は……'],feeling:'sad',result:'kagenasi'});"]
[eval exp="tyrano.plugin.kag.tmp_patterns.push({word:'みお',replies:['……無為……無為……','無為……澪？　私が……？','……え？　何を言っているの？　違う……私は……'],feeling:'sad',result:'kagenasi'});"]
[eval exp="sf.patterns_kiminonamae=tyrano.plugin.kag.tmp_patterns;"]
[endmacro]

; --- 君の名前はマッチングマクロ（挨拶・会話用・1行版） ---
[macro name="match_kiminonamae_patterns"]
[eval exp="sf.matched=false;var patterns=sf.patterns_kiminonamae;for(var i=0;i<patterns.length;i++){if(sf.input.indexOf(patterns[i].word)!=-1){var replies=patterns[i].replies;var index=Math.floor(Math.random()*replies.length);sf.reply=replies[index];sf.feeling=patterns[i].feeling;sf.result=patterns[i].result;sf.matched=true;if(sf.feeling=='positive'||sf.feeling=='relieved'){sf.shinmitsudo+=1;}if(sf.feeling=='sad'){sf.shinmitsudo-=1;}break;}}if(!sf.matched){sf.reply='';sf.feeling='none';sf.result='unknown';sf.matched=true;sf.shinmitsudo-=1;}"]
[endmacro]

; --- 1st指示パターン登録 ---
[macro name="set_instructions_patterns"]
[eval exp="tyrano.plugin.kag.tmp_patterns_instructions=[];"]
[eval exp="tyrano.plugin.kag.tmp_patterns_instructions.push({word:'タンス', replies:['分かった。タンスの引き出しを開けてみるよ'], feeling:'relieved', result:'tansu'});"]
[eval exp="tyrano.plugin.kag.tmp_patterns_instructions.push({word:'本棚', replies:['本棚だね？　何があるか見て見るよ'], feeling:'relieved', result:'book'});"]
[eval exp="tyrano.plugin.kag.tmp_patterns_instructions.push({word:'パソコン', replies:['分かった。パソコンの電源を入れてみるよ'], feeling:'relieved', result:'pc'});"]
[eval exp="tyrano.plugin.kag.tmp_patterns_instructions.push({word:'ベッド', replies:['さっき起きたばっかりだからまだ寝なくても大丈夫だよ？'], feeling:'bewildered', result:'bed'});"]
[eval exp="tyrano.plugin.kag.tmp_patterns_instructions.push({word:'引き出し', replies:['了解。引き出しを開けてみるね'], feeling:'relieved', result:'tansu'});"]
[eval exp="tyrano.plugin.kag.tmp_patterns_instructions.push({word:'植物', replies:['机の上の奴だね。ちょっと調べてみるよ'], feeling:'relieved', result:'plant'});"]
[eval exp="tyrano.plugin.kag.tmp_patterns_instructions.push({word:'部屋', replies:['部屋の中を調べるの？'], feeling:'neutral', result:'room'});"]
[eval exp="tyrano.plugin.kag.tmp_patterns_instructions.push({word:'扉', replies:['扉を調べるんだね？　行ってみるよ'], feeling:'relieved', result:'living'});"]
[eval exp="tyrano.plugin.kag.tmp_patterns_instructions.push({word:'リビング', replies:['リビングがあるの？　確かに扉はあるね。行ってみるよ'], feeling:'neutral', result:'living'});"]
[eval exp="sf.patterns_instructions=tyrano.plugin.kag.tmp_patterns_instructions;"]
[endmacro]

; --- 1st指示マッチングマクロ ---
[macro name="match_instructions_patterns"]
[eval exp="sf.matched=false;var patterns=sf.patterns_instructions;for(var i=0;i<patterns.length;i++){if(sf.input.indexOf(patterns[i].word)!=-1){var replies=patterns[i].replies;var index=Math.floor(Math.random()*replies.length);sf.reply=replies[index];sf.feeling=patterns[i].feeling;sf.result=patterns[i].result;sf.matched=true;if(sf.feeling=='positive'||sf.feeling=='relieved'){sf.shinmitsudo+=1;}if(sf.feeling=='bewildered'){sf.shinmitsudo-=1;}break;}}if(!sf.matched){sf.reply='';sf.feeling='none';sf.result='unknown';sf.matched=true;}"]
[endmacro]

; --- 朝食パターン登録 ---
[macro name="set_tyousyoku_patterns"]
[eval exp="tyrano.plugin.kag.tmp_patterns_tyousyoku=[];"]
[eval exp="tyrano.plugin.kag.tmp_patterns_tyousyoku.push({word:'おいし', replies:['そうでしょ？','ふふ。まぁね'], feeling:'positive', result:'oishii'});"]
[eval exp="tyrano.plugin.kag.tmp_patterns_tyousyoku.push({word:'美味し', replies:['そうでしょ？','ふふ。まぁね'], feeling:'positive', result:'oishii'});"]
[eval exp="tyrano.plugin.kag.tmp_patterns_tyousyoku.push({word:'上手', replies:['そうでしょ？','ふふ。まぁね'], feeling:'neutral', result:'oishii'});"]
[eval exp="tyrano.plugin.kag.tmp_patterns_tyousyoku.push({word:'多い', replies:['そうかな？　普通だよ','そう？　なんとなく作った量だったんだけど'], feeling:'bewildered', result:'ooi'});"]
[eval exp="tyrano.plugin.kag.tmp_patterns_tyousyoku.push({word:'多くない', replies:['そうかな？　普通だよ','そう？　なんとなく作った量だったんだけど'], feeling:'bewildered', result:'ooi'});"]
[eval exp="tyrano.plugin.kag.tmp_patterns_tyousyoku.push({word:'パン', replies:['パンも美味しいよね！','パン良いよね！'], feeling:'positive', result:'pan'});"]
[eval exp="tyrano.plugin.kag.tmp_patterns_tyousyoku.push({word:'洋食', replies:['洋食も美味しいよね！','洋食良いよね！'], feeling:'positive', result:'pan'});"]
[eval exp="tyrano.plugin.kag.tmp_patterns_tyousyoku.push({word:'食べない', replies:['朝はちゃんと食べたほうがいいよ','え？　お腹すかないの？'], feeling:'bewildered', result:'tabenai'});"]
[eval exp="tyrano.plugin.kag.tmp_patterns_tyousyoku.push({word:'凄い', replies:['でしょ？　ちょっと本気出した','もっと誉めてくれてもいいよ'], feeling:'positive', result:'oishii'});"]
[eval exp="tyrano.plugin.kag.tmp_patterns_tyousyoku.push({word:'すごい', replies:['でしょ？　ちょっと本気出した','もっと誉めてくれてもいいよ'], feeling:'positive', result:'oishii'});"]
[eval exp="tyrano.plugin.kag.tmp_patterns_tyousyoku.push({word:'お腹空いた', replies:['ふふ。美味しそうに見えた？','美味しそうでしょ？'], feeling:'relieved', result:'oishii'});"]
[eval exp="tyrano.plugin.kag.tmp_patterns_tyousyoku.push({word:'まず', replies:['え？　何かごめんね……','そんなこと言わなくても……'], feeling:'bewildered', result:'mazui'});"]
[eval exp="tyrano.plugin.kag.tmp_patterns_tyousyoku.push({word:'不味', replies:['え？　何かごめんね……','そんなこと言わなくても……'], feeling:'bewildered', result:'mazui'});"]
[eval exp="tyrano.plugin.kag.tmp_patterns_tyousyoku.push({word:'不味そう', replies:['え？　何かごめんね……','そんなこと言わなくても……'], feeling:'bewildered', result:'mazui'});"]
[eval exp="tyrano.plugin.kag.tmp_patterns_tyousyoku.push({word:'まずそう', replies:['え？　何かごめんね……','そんなこと言わなくても……'], feeling:'bewildered', result:'mazui'});"]
; セーブ対応変数に格納
[eval exp="sf.patterns_tyousyoku=tyrano.plugin.kag.tmp_patterns_tyousyoku;"]
[endmacro]

; --- 朝食マッチングマクロ ---
[macro name="match_tyousyoku_patterns"]
[eval exp="sf.matched=false;var patterns=sf.patterns_tyousyoku;for(var i=0;i<patterns.length;i++){if(sf.input.indexOf(patterns[i].word)!=-1){var replies=patterns[i].replies;var index=Math.floor(Math.random()*replies.length);sf.reply=replies[index];sf.feeling=patterns[i].feeling;sf.result=patterns[i].result;sf.matched=true;if(sf.feeling=='positive'||sf.feeling=='relieved'){sf.shinmitsudo+=1;}if(sf.feeling=='bewildered'){sf.shinmitsudo-=1;}break;}}if(!sf.matched){sf.reply='';sf.feeling='none';sf.result='unknown';sf.matched=true;}"]
[endmacro]

; --- 現実疑問パターン登録 ---
[macro name="set_gimon_patterns"]
[eval exp="tyrano.plugin.kag.tmp_patterns_gimon=[];"]

; 以下に自由に追加
[eval exp="tyrano.plugin.kag.tmp_patterns_gimon.push({word:'嘘', replies:['……やっぱり嘘だよね？','そうだよね。嘘だよね。'], feeling:'neutral', result:'no'});"]
[eval exp="tyrano.plugin.kag.tmp_patterns_gimon.push({word:'作り話', replies:['うん、フィクションだよね','やっぱりフィクションだよね'], feeling:'neutral', result:'no'});"]
[eval exp="tyrano.plugin.kag.tmp_patterns_gimon.push({word:'都市伝説', replies:['都市伝説みたいなはなしってこと？','作り話ってこと？'], feeling:'neutral', result:'no'});"]
[eval exp="tyrano.plugin.kag.tmp_patterns_gimon.push({word:'フィクション', replies:['うん、フィクションだよね','やっぱりフィクションだよね'], feeling:'neutral', result:'no'});"]
[eval exp="tyrano.plugin.kag.tmp_patterns_gimon.push({word:'信じない', replies:['私も、とても信じられない。','そうだよね。信じられない'], feeling:'neutral', result:'no'});"]
[eval exp="tyrano.plugin.kag.tmp_patterns_gimon.push({word:'現実じゃない', replies:['そうだよね。こんなのが現実だと思えない','うん。とても現実だとは思えない'], feeling:'neutral', result:'no'});"]
[eval exp="tyrano.plugin.kag.tmp_patterns_gimon.push({word:'陰謀論', replies:['それぐらいの大嘘だよね','陰謀論って言われたほうが信じられるよ'], feeling:'neutral', result:'no'});"]
[eval exp="tyrano.plugin.kag.tmp_patterns_gimon.push({word:'あるわけない', replies:['そうだよね。あるわけないよね。','うん。私もあるわけないって思う'], feeling:'neutral', result:'no'});"]

[eval exp="tyrano.plugin.kag.tmp_patterns_gimon.push({word:'信じる', replies:['……え？　本当に？','え？　そうなの？'], feeling:'surprised', result:'yes'});"]
[eval exp="tyrano.plugin.kag.tmp_patterns_gimon.push({word:'ある', replies:['……そうなんだ。これ現実なんだ。','本当に現実なの？'], feeling:'surprised', result:'yes'});"]
[eval exp="tyrano.plugin.kag.tmp_patterns_gimon.push({word:'現実だ', replies:['え？　本当に？','え？　これ現実なの？'], feeling:'surprised', result:'yes'});"]
[eval exp="tyrano.plugin.kag.tmp_patterns_gimon.push({word:'本当にあった', replies:['嘘？　本当に？','え？　そうなの？'], feeling:'surprised', result:'yes'});"]
[eval exp="tyrano.plugin.kag.tmp_patterns_gimon.push({word:'あった', replies:['嘘？　本当に？','え？　そうなの？'], feeling:'surprised', result:'yes'});"]

[eval exp="tyrano.plugin.kag.tmp_patterns_gimon.push({word:'教えない', replies:['え？　どうして？','え？　教えてよ？'], feeling:'surprised', result:'not'});"]
[eval exp="tyrano.plugin.kag.tmp_patterns_gimon.push({word:'知らなくていい', replies:['え？　どうして？','え？　教えてよ？'], feeling:'surprised', result:'not'});"]
[eval exp="tyrano.plugin.kag.tmp_patterns_gimon.push({word:'知る必要がない', replies:['え？　どうして？','え？　教えてよ？'], feeling:'surprised', result:'not'});"]
[eval exp="tyrano.plugin.kag.tmp_patterns_gimon.push({word:'知らないほうがいい', replies:['え？　どうして？','え？　教えてよ？'], feeling:'surprised', result:'not'});"]

; セーブ対応変数に格納
[eval exp="sf.patterns_gimon=tyrano.plugin.kag.tmp_patterns_gimon;"]
[endmacro]

; --- 疑問マッチングマクロ ---
[macro name="match_gimon_patterns"]
[eval exp="sf.matched=false;var patterns=sf.patterns_gimon;for(var i=0;i<patterns.length;i++){if(sf.input.indexOf(patterns[i].word)!=-1){var replies=patterns[i].replies;var index=Math.floor(Math.random()*replies.length);sf.reply=replies[index];sf.feeling=patterns[i].feeling;sf.result=patterns[i].result;sf.matched=true;if(sf.feeling=='positive'||sf.feeling=='relieved'){sf.shinmitsudo+=1;}if(sf.feeling=='bewildered'){sf.shinmitsudo-=1;}break;}}if(!sf.matched){sf.reply='';sf.feeling='none';sf.result='unknown';sf.matched=true;}"]
[endmacro]


; 探索パターン登録
[macro name="set_tansaku_patterns"]
[eval exp="tyrano.plugin.kag.tmp_patterns_tansaku=[];"]

[eval exp="tyrano.plugin.kag.tmp_patterns_tansaku.push({word:'本棚', replies:['……ああ。そう言えば新聞のスクラップとかあったね','そうだよね。前に調べようっていってたよね。'], feeling:'neutral', result:'hodana'});"]
[eval exp="tyrano.plugin.kag.tmp_patterns_tansaku.push({word:'ほんだな', replies:['……ああ。そう言えば新聞のスクラップとかあったね','そうだよね。前に調べようっていってたよね。'], feeling:'neutral', result:'hondan'});"]
[eval exp="tyrano.plugin.kag.tmp_patterns_tansaku.push({word:'ベッド', replies:['……ベッドなんて調べても何もないと思うよ？','ベットの下ってこと？'], feeling:'bewildered', result:'bed'});"]
[eval exp="tyrano.plugin.kag.tmp_patterns_tansaku.push({word:'植物', replies:['……ただの観葉植物だよ？　見て見るけど。','植物を調べてみる？　ただのイミテーションだよ？'], feeling:'bewildered', result:'syokubutu'});"]
[eval exp="tyrano.plugin.kag.tmp_patterns_tansaku.push({word:'リビング', replies:['……リビング調べてみる？','そうだよね。隣の部屋？　行ってみるよ'], feeling:'neutral', result:'living'});"]
[eval exp="tyrano.plugin.kag.tmp_patterns_tansaku.push({word:'鍵', replies:['……鍵の掛かった部屋の事？　でも、あそこは入れないよ？','リビングの部屋のこと？　でも入れないよ？'], feeling:'surprised', result:'rock'});"]
[eval exp="tyrano.plugin.kag.tmp_patterns_tansaku.push({word:'カギ', replies:['……鍵の掛かった部屋の事？　でも、あそこは入れないよ？','リビングの部屋のこと？　でも入れないよ？'], feeling:'surprised', result:'rock'});"]
[eval exp="tyrano.plugin.kag.tmp_patterns_tansaku.push({word:'開かない部屋', replies:['……鍵の掛かった部屋の事？　でも、あそこは入れないよ？','リビングの部屋のこと？　でも入れないよ？'], feeling:'surprised', result:'rock'});"]
[eval exp="tyrano.plugin.kag.tmp_patterns_tansaku.push({word:'パソコンの裏', replies:['……パソコンの裏？　どうしてそんなところを？','不思議な事言うね？　どうしてそんなところを？'], feeling:'surprised', result:'back'});"]
[eval exp="tyrano.plugin.kag.tmp_patterns_tansaku.push({word:'モニターの裏', replies:['……モニターの裏？　どうしてそんなところを？','不思議な事言うね？　どうしてそんなところを？'], feeling:'surprised', result:'back'});"]
[eval exp="tyrano.plugin.kag.tmp_patterns_tansaku.push({word:'パソコン裏', replies:['……裏？　パソコンの裏のこと？','裏？　モニターの裏のこと？'], feeling:'surprised', result:'back'});"]
[eval exp="tyrano.plugin.kag.tmp_patterns_tansaku.push({word:'PC裏', replies:['……裏？　パソコンの裏のこと？','裏？　モニターの裏のこと？'], feeling:'surprised', result:'back'});"]
[eval exp="tyrano.plugin.kag.tmp_patterns_tansaku.push({word:'モニター裏', replies:['……裏？　パソコンの裏のこと？','裏？　モニターの裏のこと？'], feeling:'surprised', result:'back'});"]

; セーブ対応変数に格納
[eval exp="sf.patterns_tansaku=tyrano.plugin.kag.tmp_patterns_tansaku;"]
[endmacro]
; ---探索マッチングマクロ ---
[macro name="match_tansaku_patterns"]
[eval exp="sf.matched=false;var patterns=sf.patterns_tansaku;for(var i=0;i<patterns.length;i++){if(sf.input.indexOf(patterns[i].word)!=-1){var replies=patterns[i].replies;var index=Math.floor(Math.random()*replies.length);sf.reply=replies[index];sf.feeling=patterns[i].feeling;sf.result=patterns[i].result;sf.matched=true;if(sf.feeling=='positive'||sf.feeling=='relieved'){sf.shinmitsudo+=1;}if(sf.feeling=='bewildered'){sf.shinmitsudo-=1;}break;}}if(!sf.matched){sf.reply='';sf.feeling='none';sf.result='unknown';sf.matched=true;}"]
[endmacro]

; 抗体パターン登録
[macro name="set_koutai_patterns"]
[eval exp="tyrano.plugin.kag.tmp_patterns_koutai=[];"]

[eval exp="tyrano.plugin.kag.tmp_patterns_koutai.push({word:'知って', replies:['……どうして教えてくれなかったの！？','どうして、黙ってたの！？'], feeling:'angry', result:'know'});"]
[eval exp="tyrano.plugin.kag.tmp_patterns_koutai.push({word:'知らな', replies:['……本当に？','知らなかった？　嘘でしょ？'], feeling:'neutral', result:'dontknow'});"]
[eval exp="tyrano.plugin.kag.tmp_patterns_koutai.push({word:'そうだ', replies:['……知ってて黙ってたの！？','教えてよ！？'], feeling:'angry', result:'know'});"]
[eval exp="tyrano.plugin.kag.tmp_patterns_koutai.push({word:'うん', replies:['……知ってたのにどうして教えてくれなかったの！・。','知ってたなら教えてよ！？'], feeling:'angry', result:'know'});"]
[eval exp="tyrano.plugin.kag.tmp_patterns_koutai.push({word:'ううん', replies:['……本当に？','知らなかった？　嘘でしょ？'], feeling:'neutral', result:'dontknow'});"]
[eval exp="tyrano.plugin.kag.tmp_patterns_koutai.push({word:'どう思う', replies:['……私を試してるの？','初めから知っていたとしか思えない'], feeling:'bewildered', result:'question'});"]
[eval exp="tyrano.plugin.kag.tmp_patterns_koutai.push({word:'分からない', replies:['……分からないなんてことある？','どうして自分のことが分からないの？'], feeling:'bewildered', result:'notclear'});"]

; セーブ対応変数に格納
[eval exp="sf.patterns_koutai=tyrano.plugin.kag.tmp_patterns_koutai;"]
[endmacro]
; ---抗体マッチングマクロ ---
[macro name="match_koutai_patterns"]
[eval exp="sf.matched=false;var patterns=sf.patterns_koutai;for(var i=0;i<patterns.length;i++){if(sf.input.indexOf(patterns[i].word)!=-1){var replies=patterns[i].replies;var index=Math.floor(Math.random()*replies.length);sf.reply=replies[index];sf.feeling=patterns[i].feeling;sf.result=patterns[i].result;sf.matched=true;if(sf.feeling=='positive'||sf.feeling=='relieved'){sf.shinmitsudo+=1;}if(sf.feeling=='bewildered'){sf.shinmitsudo-=1;}break;}}if(!sf.matched){sf.reply='';sf.feeling='none';sf.result='unknown';sf.matched=true;}"]
[endmacro]

; 質問パターン登録
[macro name="set_shitsumon_patterns"]
[eval exp="tyrano.plugin.kag.tmp_patterns_shitsumon=[];"]

[eval exp="tyrano.plugin.kag.tmp_patterns_shitsumon.push({word:'無い', replies:['うん。続けるね','おっけー。続けるよ'], feeling:'default', result:'ok'});"]
[eval exp="tyrano.plugin.kag.tmp_patterns_shitsumon.push({word:'続けて', replies:['うん。続けるね','おっけー。続けるよ'], feeling:'default', result:'ok'});"]
[eval exp="tyrano.plugin.kag.tmp_patterns_shitsumon.push({word:'大丈夫', replies:['うん。続けるね','おっけー。続けるよ'], feeling:'default', result:'ok'});"]
[eval exp="tyrano.plugin.kag.tmp_patterns_shitsumon.push({word:'ありません', replies:['うん。続けるね','おっけー。続けるよ'], feeling:'default', result:'ok'});"]
[eval exp="tyrano.plugin.kag.tmp_patterns_shitsumon.push({word:'戻った', replies:['記憶は戻ってないよ','ううん。全然思い出せない'], feeling:'sad', result:'kioku'});"]
[eval exp="tyrano.plugin.kag.tmp_patterns_shitsumon.push({word:'記憶', replies:['記憶は戻ってないよ','ううん。全然思い出せない'], feeling:'sad', result:'kioku'});"]
[eval exp="tyrano.plugin.kag.tmp_patterns_shitsumon.push({word:'名前', replies:['自分の名前に実感はないかな','本当に私って天音亜音なのかな？'], feeling:'neutral', result:'name'});"]
[eval exp="tyrano.plugin.kag.tmp_patterns_shitsumon.push({word:'監禁', replies:['やっぱり閉じ込められてると思う？','やっぱり監禁されてるのかな？'], feeling:'neutral', result:'escape'});"]
[eval exp="tyrano.plugin.kag.tmp_patterns_shitsumon.push({word:'閉じ込め', replies:['やっぱり閉じ込められてると思う？','やっぱり監禁されてるのかな？'], feeling:'neutral', result:'escape'});"]
[eval exp="tyrano.plugin.kag.tmp_patterns_shitsumon.push({word:'脱出', replies:['部屋からは出たいよ。','ここからは逃げたいと思ってる'], feeling:'neutral', result:'escape'});"]
[eval exp="tyrano.plugin.kag.tmp_patterns_shitsumon.push({word:'逃げ', replies:['部屋からは出たいよ。','ここからは逃げたいと思ってる'], feeling:'neutral', result:'escape'});"]
[eval exp="tyrano.plugin.kag.tmp_patterns_shitsumon.push({word:'一界一心会', replies:['一界一心会についてはまったく思い出せないんだ。','一界一心会については全然分からないんだ'], feeling:'neutral', result:'issinkai'});"]
[eval exp="tyrano.plugin.kag.tmp_patterns_shitsumon.push({word:'抗体', replies:['私が抗体を持っているっていうのは正直、半信半疑なんだけどね','本当に私が抗体を持っているのかは半信半疑なんだ'], feeling:'neutral', result:'koutai'});"]
[eval exp="tyrano.plugin.kag.tmp_patterns_shitsumon.push({word:'カウンセリング', replies:['白石先生とのカウンセリングは私が受けていたんだよね？','白石先生との音声データで話しているのは私なんだよね？'], feeling:'neutral', result:'counseling'});"]
[eval exp="tyrano.plugin.kag.tmp_patterns_shitsumon.push({word:'白石', replies:['白石先生とのカウンセリングは私が受けていたんだよね？','白石先生との音声データで話しているのは私なんだよね？'], feeling:'neutral', result:'counseling'});"]
[eval exp="tyrano.plugin.kag.tmp_patterns_shitsumon.push({word:'結花', replies:['白石先生とのカウンセリングは私が受けていたんだよね？','白石先生との音声データで話しているのは私なんだよね？'], feeling:'neutral', result:'izumi'});"]
[eval exp="tyrano.plugin.kag.tmp_patterns_shitsumon.push({word:'朧音', replies:['朧音いずみさんは私ってことになるのかな？','私が朧音いずみさんだったってことなのかな？'], feeling:'neutral', result:'izumi'});"]
[eval exp="tyrano.plugin.kag.tmp_patterns_shitsumon.push({word:'ない', replies:['うん。続けるね','おっけー。続けるよ'], feeling:'default', result:'ok'});"]
[eval exp="tyrano.plugin.kag.tmp_patterns_shitsumon.push({word:'ある', replies:['何が聞きたいの？','何について聞きたい？'], feeling:'default', result:'question'});"]

; セーブ対応変数に格納
[eval exp="sf.patterns_shitsumon=tyrano.plugin.kag.tmp_patterns_shitsumon;"]
[endmacro]
; ---質問マッチングマクロ ---
[macro name="match_shitsumon_patterns"]
[eval exp="sf.matched=false;var patterns=sf.patterns_shitsumon;for(var i=0;i<patterns.length;i++){if(sf.input.indexOf(patterns[i].word)!=-1){var replies=patterns[i].replies;var index=Math.floor(Math.random()*replies.length);sf.reply=replies[index];sf.feeling=patterns[i].feeling;sf.result=patterns[i].result;sf.matched=true;if(sf.feeling=='positive'||sf.feeling=='relieved'){sf.shinmitsudo+=1;}if(sf.feeling=='bewildered'){sf.shinmitsudo-=1;}break;}}if(!sf.matched){sf.reply='';sf.feeling='none';sf.result='unknown';sf.matched=true;}"]
[endmacro]

; 差し出すパターン登録
[macro name="set_sasidasu_patterns"]
[eval exp="tyrano.plugin.kag.tmp_patterns_sasidasu=[];"]

[eval exp="tyrano.plugin.kag.tmp_patterns_sasidasu.push({word:'差し出さな', replies:['……差し出さなくていいのかな。','差し出さなくていい……そうなのかな……'], feeling:'sad', result:'no'});"]
[eval exp="tyrano.plugin.kag.tmp_patterns_sasidasu.push({word:'違う', replies:['……差し出さなくていいのかな。','差し出さなくていい……そうなのかな……'], feeling:'sad', result:'no'});"]
[eval exp="tyrano.plugin.kag.tmp_patterns_sasidasu.push({word:'必要ない', replies:['……差し出さなくていいのかな。','差し出さなくていい……そうなのかな……'], feeling:'sad', result:'no'});"]
[eval exp="tyrano.plugin.kag.tmp_patterns_sasidasu.push({word:'いらない', replies:['……差し出さなくていいのかな。','差し出さなくていい……そうなのかな……'], feeling:'sad', result:'no'});"]
[eval exp="tyrano.plugin.kag.tmp_patterns_sasidasu.push({word:'しなくていい', replies:['……差し出さなくていいのかな。','差し出さなくていい……そうなのかな……'], feeling:'sad', result:'no'});"]
[eval exp="tyrano.plugin.kag.tmp_patterns_sasidasu.push({word:'差し出す', replies:['やっぱり、そうなのかな。','やっぱり、そのほうがいいよね'], feeling:'neutral', result:'sasidasu'});"]
[eval exp="tyrano.plugin.kag.tmp_patterns_sasidasu.push({word:'そう', replies:['やっぱり、そうなのかな。','やっぱり、そのほうがいいよね'], feeling:'neutral', result:'sasidasu'});"]
[eval exp="tyrano.plugin.kag.tmp_patterns_sasidasu.push({word:'その通り', replies:['やっぱり、そうなのかな。','やっぱり、そのほうがいいよね'], feeling:'neutral', result:'sasidasu'});"]
[eval exp="tyrano.plugin.kag.tmp_patterns_sasidasu.push({word:'うん', replies:['やっぱり、そうなのかな。','やっぱり、そのほうがいいよね'], feeling:'neutral', result:'sasidasu'});"]

; セーブ対応変数に格納
[eval exp="sf.patterns_sasidasu=tyrano.plugin.kag.tmp_patterns_sasidasu;"]
[endmacro]
; ---差し出すマッチングマクロ ---
[macro name="match_sasidasu_patterns"]
[eval exp="sf.matched=false;var patterns=sf.patterns_sasidasu;for(var i=0;i<patterns.length;i++){if(sf.input.indexOf(patterns[i].word)!=-1){var replies=patterns[i].replies;var index=Math.floor(Math.random()*replies.length);sf.reply=replies[index];sf.feeling=patterns[i].feeling;sf.result=patterns[i].result;sf.matched=true;if(sf.feeling=='positive'||sf.feeling=='relieved'){sf.shinmitsudo+=1;}if(sf.feeling=='bewildered'){sf.shinmitsudo-=1;}break;}}if(!sf.matched){sf.reply='';sf.feeling='none';sf.result='unknown';sf.matched=true;}"]
[endmacro]

; パスワードパターン登録
[macro name="set_password_patterns"]
[eval exp="tyrano.plugin.kag.tmp_patterns_password=[];"]
[eval exp="tyrano.plugin.kag.tmp_patterns_password.push({word:'初配信', replies:['初配信日？　覚えてるよ','朧音いずみさんの初配信日？ 覚えてるよ'], feeling:'neutral', result:'hatuhaisin'});"]
[eval exp="tyrano.plugin.kag.tmp_patterns_password.push({word:'事変', replies:['一界一心会事変があった日？　いつだったっけな？','あんまりはっきり覚えてないけど……'], feeling:'neutral', result:'jihen'});"]
[eval exp="tyrano.plugin.kag.tmp_patterns_password.push({word:'命日', replies:['……はっきり分かってたっけ？','いつだったかな？　日記の日付はむちゃくちゃになってたから……'], feeling:'neutral', result:'meinichi'});"]
[eval exp="tyrano.plugin.kag.tmp_patterns_password.push({word:'命名された日', replies:['……たしか新聞記事に載ってたよね？','新聞の記事に載ってた気がするけど……'], feeling:'neutral', result:'hakken'});"]
[eval exp="tyrano.plugin.kag.tmp_patterns_password.push({word:'誕生日', replies:['……私の誕生日？　覚えてないよ……','誕生日？　いつだったっけ？'], feeling:'neutral', result:'barthday'});"]
[eval exp="tyrano.plugin.kag.tmp_patterns_password.push({word:'天音', replies:['……私？　その可能性もあるのか','私？　ここが私の部屋だとしたらありえるかもね'], feeling:'neutral', result:'amane'});"]
[eval exp="tyrano.plugin.kag.tmp_patterns_password.push({word:'亜音', replies:['……私？　その可能性もあるのか','私？　ここが私の部屋だとしたらありえるかもね'], feeling:'neutral', result:'amane'});"]
[eval exp="tyrano.plugin.kag.tmp_patterns_password.push({word:'君', replies:['……私？　その可能性もあるのか','私？　ここが私の部屋だとしたらありえるかもね'], feeling:'neutral', result:'amane'});"]
[eval exp="tyrano.plugin.kag.tmp_patterns_password.push({word:'あなた', replies:['……私？　その可能性もあるのか','私？　ここが私の部屋だとしたらありえるかもね'], feeling:'neutral', result:'amane'});"]

[eval exp="tyrano.plugin.kag.tmp_patterns_password.push({word:'分からない', replies:['難しいよね……','そうだよね……'], feeling:'neutral', result:'not'});"]
[eval exp="tyrano.plugin.kag.tmp_patterns_password.push({word:'無い', replies:['難しいよね……','そうだよね……'], feeling:'neutral', result:'not'});"]
[eval exp="tyrano.plugin.kag.tmp_patterns_password.push({word:'しらない', replies:['難しいよね……','そうだよね……'], feeling:'neutral', result:'not'});"]
[eval exp="tyrano.plugin.kag.tmp_patterns_password.push({word:'知らない', replies:['難しいよね……','そうだよね……'], feeling:'neutral', result:'not'});"]
[eval exp="tyrano.plugin.kag.tmp_patterns_password.push({word:'わからない', replies:['難しいよね……','そうだよね……'], feeling:'neutral', result:'not'});"]
[eval exp="tyrano.plugin.kag.tmp_patterns_password.push({word:'一界一心会', replies:['一界一心会が関係してると思う？','一界一心会？'], feeling:'neutral', result:'isshinkai'});"]
[eval exp="tyrano.plugin.kag.tmp_patterns_password.push({word:'朧音', replies:['朧音いずみさんが関係していると思う？　確かに気になるよね','朧音いずみさん？　確かに気になるよね'], feeling:'neutral', result:'oborone'});"]
[eval exp="tyrano.plugin.kag.tmp_patterns_password.push({word:'いずみ', replies:['朧音いずみさんが関係していると思う？　確かに気になるよね','朧音いずみさん？　確かに気になるよね'], feeling:'neutral', result:'oborone'});"]
[eval exp="tyrano.plugin.kag.tmp_patterns_password.push({word:'白石', replies:['白石先生が関係していると思う？','白石先生？'], feeling:'neutral', result:'shiraishi'});"]
[eval exp="tyrano.plugin.kag.tmp_patterns_password.push({word:'結花', replies:['白石先生が関係していると思う？','白石先生？'], feeling:'neutral', result:'shiraishi'});"]
[eval exp="tyrano.plugin.kag.tmp_patterns_password.push({word:'灰化病', replies:['灰化病？　確かにここに閉じ込められている理由かもしれないもんね','灰化病の抗体が原因で閉じ込められているかもしれないもんね'], feeling:'neutral', result:'haikabyo'});"]
[eval exp="tyrano.plugin.kag.tmp_patterns_password.push({word:'出られない', replies:['どうしてそう言う事言うの？','本気で言ってる？'], feeling:'sad', result:'derarenai'});"]
[eval exp="tyrano.plugin.kag.tmp_patterns_password.push({word:'ない', replies:['難しいよね……','そうだよね……'], feeling:'neutral', result:'not'});"]
[eval exp="tyrano.plugin.kag.tmp_patterns_password.push({word:'入力', replies:['パスワードを入力するんだね？　分かったよ','パスワードを入力するの？　おっけー'], feeling:'neutral', result:'nyuryoku'});"]

; セーブ対応変数に格納
[eval exp="sf.patterns_password=tyrano.plugin.kag.tmp_patterns_password;"]
[endmacro]
; ---パスワードマッチングマクロ ---
[macro name="match_password_patterns"]
[eval exp="sf.matched=false;var patterns=sf.patterns_password;for(var i=0;i<patterns.length;i++){if(sf.input.indexOf(patterns[i].word)!=-1){var replies=patterns[i].replies;var index=Math.floor(Math.random()*replies.length);sf.reply=replies[index];sf.feeling=patterns[i].feeling;sf.result=patterns[i].result;sf.matched=true;if(sf.feeling=='positive'||sf.feeling=='relieved'){sf.shinmitsudo+=1;}if(sf.feeling=='bewildered'){sf.shinmitsudo-=1;}break;}}if(!sf.matched){sf.reply='';sf.feeling='none';sf.result='unknown';sf.matched=true;}"]
[endmacro]

; 廊下行動パターン登録
[macro name="set_roka_patterns"]
[eval exp="tyrano.plugin.kag.tmp_patterns_roka=[];"]

[eval exp="tyrano.plugin.kag.tmp_patterns_roka.push({word:'逃げ', replies:['うん、そうする','分かった'], feeling:'sad', result:'nigeru'});"]
[eval exp="tyrano.plugin.kag.tmp_patterns_roka.push({word:'にげ', replies:['うん、そうする','分かった'], feeling:'sad', result:'nigeru'});"]
[eval exp="tyrano.plugin.kag.tmp_patterns_roka.push({word:'逃走', replies:['うん、そうする','分かった'], feeling:'sad', result:'nigeru'});"]
[eval exp="tyrano.plugin.kag.tmp_patterns_roka.push({word:'会話', replies:['女の人は話が通じそう。分かった。やってみる','そうだね。あの女の人は話は通じそう'], feeling:'neutral', result:'kaiwa'});"]
[eval exp="tyrano.plugin.kag.tmp_patterns_roka.push({word:'話し', replies:['女の人は話が通じそう。分かった。やってみる','そうだね。あの女の人は話は通じそう'], feeling:'neutral', result:'kaiwa'});"]
[eval exp="tyrano.plugin.kag.tmp_patterns_roka.push({word:'話', replies:['女の人は話が通じそう。分かった。やってみる','そうだね。あの女の人は話は通じそう'], feeling:'neutral', result:'kaiwa'});"]
[eval exp="tyrano.plugin.kag.tmp_patterns_roka.push({word:'戦う', replies:['本気で言ってるの？　銃持ってるんだよ？','本気？　拳銃持ってるんだよ？'], feeling:'surprised', result:'fight'});"]
[eval exp="tyrano.plugin.kag.tmp_patterns_roka.push({word:'闘う', replies:['本気で言ってるの？　銃持ってるんだよ？','本気？　拳銃持ってるんだよ？'], feeling:'surprised', result:'fight'});"]
[eval exp="tyrano.plugin.kag.tmp_patterns_roka.push({word:'たたかう', replies:['本気で言ってるの？　銃持ってるんだよ？','本気？　拳銃持ってるんだよ？'], feeling:'surprised', result:'fight'});"]
[eval exp="tyrano.plugin.kag.tmp_patterns_roka.push({word:'応戦', replies:['本気で言ってるの？　銃持ってるんだよ？','本気？　拳銃持ってるんだよ？'], feeling:'surprised', result:'fight'});"]
[eval exp="tyrano.plugin.kag.tmp_patterns_roka.push({word:'戦', replies:['本気で言ってるの？　銃持ってるんだよ？','本気？　拳銃持ってるんだよ？'], feeling:'surprised', result:'fight'});"]
[eval exp="tyrano.plugin.kag.tmp_patterns_roka.push({word:'闘', replies:['本気で言ってるの？　銃持ってるんだよ？','本気？　拳銃持ってるんだよ？'], feeling:'surprised', result:'fight'});"]

; セーブ対応変数に格納
[eval exp="sf.patterns_roka=tyrano.plugin.kag.tmp_patterns_roka;"]
[endmacro]
; ---廊下マッチングマクロ ---
[macro name="match_roka_patterns"]
[eval exp="sf.matched=false;var patterns=sf.patterns_roka;for(var i=0;i<patterns.length;i++){if(sf.input.indexOf(patterns[i].word)!=-1){var replies=patterns[i].replies;var index=Math.floor(Math.random()*replies.length);sf.reply=replies[index];sf.feeling=patterns[i].feeling;sf.result=patterns[i].result;sf.matched=true;if(sf.feeling=='positive'||sf.feeling=='relieved'){sf.shinmitsudo+=1;}if(sf.feeling=='bewildered'){sf.shinmitsudo-=1;}break;}}if(!sf.matched){sf.reply='';sf.feeling='none';sf.result='unknown';sf.matched=true;}"]
[endmacro]


; 決断パターン登録
[macro name="set_ketsudan_patterns"]
[eval exp="tyrano.plugin.kag.tmp_patterns_ketsudan=[];"]

[eval exp="tyrano.plugin.kag.tmp_patterns_ketsudan.push({word:'隠れ', replies:['自分自身で隠れてると思う？','私が自分の意思で隠れてるってことだよね？'], feeling:'neutral', result:'kakureru'});"]
[eval exp="tyrano.plugin.kag.tmp_patterns_ketsudan.push({word:'かくれ', replies:['自分自身で隠れてると思う？','私が自分の意思で隠れてるってことだよね？'], feeling:'neutral', result:'kakureru'});"]
[eval exp="tyrano.plugin.kag.tmp_patterns_ketsudan.push({word:'監禁', replies:['私は監禁されてると思う？','誰かに閉じ込められているって思う？'], feeling:'neutral', result:'fan'});"]
[eval exp="tyrano.plugin.kag.tmp_patterns_ketsudan.push({word:'閉じ込め', replies:['私は監禁されてると思う？','誰かに閉じ込められているって思う？'], feeling:'neutral', result:'fan'});"]

; セーブ対応変数に格納
[eval exp="sf.patterns_ketsudan=tyrano.plugin.kag.tmp_patterns_ketsudan;"]
[endmacro]


; ---決断マッチングマクロ ---
[macro name="match_ketsudan_patterns"]
[eval exp="sf.matched=false;var patterns=sf.patterns_ketsudan;for(var i=0;i<patterns.length;i++){if(sf.input.indexOf(patterns[i].word)!=-1){var replies=patterns[i].replies;var index=Math.floor(Math.random()*replies.length);sf.reply=replies[index];sf.feeling=patterns[i].feeling;sf.result=patterns[i].result;sf.matched=true;if(sf.feeling=='positive'||sf.feeling=='relieved'){sf.shinmitsudo+=1;}if(sf.feeling=='bewildered'){sf.shinmitsudo-=1;}break;}}if(!sf.matched){sf.reply='';sf.feeling='none';sf.result='unknown';sf.matched=true;}"]
[endmacro]

; 狂信的ファン行動パターン登録
[macro name="set_fan_patterns"]
[eval exp="tyrano.plugin.kag.tmp_patterns_fan=[];"]

[eval exp="tyrano.plugin.kag.tmp_patterns_fan.push({word:'うん', replies:['そうだよね。私もそう思う','やっぱりそうだよね'], feeling:'default ', result:'yes'});"]
[eval exp="tyrano.plugin.kag.tmp_patterns_fan.push({word:'そう', replies:['そうだよね。私もそう思う','やっぱりそうだよね'], feeling:'default ', result:'yes'});"]
[eval exp="tyrano.plugin.kag.tmp_patterns_fan.push({word:'間違いない', replies:['そうだよね。私もそう思う','やっぱりそうだよね'], feeling:'default ', result:'yes'});"]
[eval exp="tyrano.plugin.kag.tmp_patterns_fan.push({word:'いいえ', replies:['え？　どうして？','違うの？　君が言い出したんだよ？'], feeling:'sad ', result:'no'});"]
[eval exp="tyrano.plugin.kag.tmp_patterns_fan.push({word:'いい', replies:['そうだよね。私もそう思う','やっぱりそうだよね'], feeling:'default ', result:'yes'});"]
[eval exp="tyrano.plugin.kag.tmp_patterns_fan.push({word:'良い', replies:['そうだよね。私もそう思う','やっぱりそうだよね'], feeling:'default ', result:'yes'});"]
[eval exp="tyrano.plugin.kag.tmp_patterns_fan.push({word:'はい', replies:['そうだよね。私もそう思う','やっぱりそうだよね'], feeling:'default ', result:'yes'});"]
[eval exp="tyrano.plugin.kag.tmp_patterns_fan.push({word:'その通り', replies:['そうだよね。私もそう思う','やっぱりそうだよね'], feeling:'default ', result:'yes'});"]
[eval exp="tyrano.plugin.kag.tmp_patterns_fan.push({word:'違', replies:['え？　どうして？','違うの？　君が言い出したんだよ？'], feeling:'sad ', result:'no'});"]
[eval exp="tyrano.plugin.kag.tmp_patterns_fan.push({word:'駄目', replies:['え？　どうして？','違うの？　君が言い出したんだよ？'], feeling:'sad ', result:'no'});"]
[eval exp="tyrano.plugin.kag.tmp_patterns_fan.push({word:'ダメ', replies:['え？　どうして？','違うの？　君が言い出したんだよ？'], feeling:'sad ', result:'no'});"]
[eval exp="tyrano.plugin.kag.tmp_patterns_fan.push({word:'間違い', replies:['え？　どうして？','違うの？　君が言い出したんだよ？'], feeling:'sad ', result:'no'});"]


; セーブ対応変数に格納
[eval exp="sf.patterns_fan=tyrano.plugin.kag.tmp_patterns_fan;"]
[endmacro]
; ---狂信者ファンのマッチングマクロ ---
[macro name="match_fan_patterns"]
[eval exp="sf.matched=false;var patterns=sf.patterns_fan;for(var i=0;i<patterns.length;i++){if(sf.input.indexOf(patterns[i].word)!=-1){var replies=patterns[i].replies;var index=Math.floor(Math.random()*replies.length);sf.reply=replies[index];sf.feeling=patterns[i].feeling;sf.result=patterns[i].result;sf.matched=true;if(sf.feeling=='positive'||sf.feeling=='relieved'){sf.shinmitsudo+=1;}if(sf.feeling=='bewildered'){sf.shinmitsudo-=1;}break;}}if(!sf.matched){sf.reply='';sf.feeling='none';sf.result='unknown';sf.matched=true;}"]
[endmacro]

; 秘密パターン登録
[macro name="set_himitsu_patterns"]
[eval exp="tyrano.plugin.kag.tmp_patterns_himitsu=[];"]

[eval exp="tyrano.plugin.kag.tmp_patterns_himitsu.push({word:'灰化病', replies:['私が？　病気？','嘘でしょ。私が病気？'], feeling:'surprise', result:'haikabyo'});"]
[eval exp="tyrano.plugin.kag.tmp_patterns_himitsu.push({word:'病', replies:['私が？　病気？','嘘でしょ。私が病気？'], feeling:'surprise', result:'haikabyo'});"]
[eval exp="tyrano.plugin.kag.tmp_patterns_himitsu.push({word:'ない', replies:['私のことを信用できないってこと？','私には話せないってこと？'], feeling:'neutral', result:'utiakenai'});"]
[eval exp="tyrano.plugin.kag.tmp_patterns_himitsu.push({word:'教えない', replies:['私のことを信用できないってこと？','私には話せないってこと？'], feeling:'neutral', result:'utiakenai'});"]
[eval exp="tyrano.plugin.kag.tmp_patterns_himitsu.push({word:'教えたくない', replies:['私のことを信用できないってこと？','私には話せないってこと？'], feeling:'neutral', result:'utiakenai'});"]
[eval exp="tyrano.plugin.kag.tmp_patterns_himitsu.push({word:'教えない', replies:['私のことを信用できないってこと？','私には話せないってこと？'], feeling:'neutral', result:'utiakenai'});"]
[eval exp="tyrano.plugin.kag.tmp_patterns_himitsu.push({word:'言えない', replies:['私のことを信用できないってこと？','私には話せないってこと？'], feeling:'neutral', result:'utiakenai'});"]
[eval exp="tyrano.plugin.kag.tmp_patterns_himitsu.push({word:'言わない', replies:['私のことを信用できないってこと？','私には話せないってこと？'], feeling:'neutral', result:'utiakenai'});"]
[eval exp="tyrano.plugin.kag.tmp_patterns_himitsu.push({word:'言いたくない', replies:['私のことを信用できないってこと？','私には話せないってこと？'], feeling:'neutral', result:'utiakenai'});"]
[eval exp="tyrano.plugin.kag.tmp_patterns_himitsu.push({word:'監視', replies:['君は誰かに私を監視しろって言われてるの？','君は私を監視しろって言われてるの？'], feeling:'neutral', result:'sentaku'});"]
[eval exp="tyrano.plugin.kag.tmp_patterns_himitsu.push({word:'選択', replies:['君は誰かに私を助けるか助けないかを選択しろって言われてるの？','君は私を助けるかどうかを決めろって言われてるの？'], feeling:'neutral', result:'sentaku'});"]
[eval exp="tyrano.plugin.kag.tmp_patterns_himitsu.push({word:'救い出すかどうか', replies:['君は誰かに私を助けるか助けないかを選択しろって言われてるの？','君は私を助けるかどうかを決めろって言われてるの？'], feeling:'neutral', result:'sentaku'});"]
[eval exp="tyrano.plugin.kag.tmp_patterns_himitsu.push({word:'助けるかどうか', replies:['君は誰かに私を助けるか助けないかを選択しろって言われてるの？','君は私を助けるかどうかを決めろって言われてるの？'], feeling:'neutral', result:'sentaku'});"]
[eval exp="tyrano.plugin.kag.tmp_patterns_himitsu.push({word:'決め', replies:['君は誰かに私を助けるか助けないかを選択しろって言われてるの？','君は私を助けるかどうかを決めろって言われてるの？'], feeling:'neutral', result:'sentaku'});"]
[eval exp="tyrano.plugin.kag.tmp_patterns_himitsu.push({word:'仕事', replies:['君は私を助けるか助けないかを選択するのが仕事っていうの？','君は私を助けるかどうかを決めるのが仕事って言われてるの？'], feeling:'neutral', result:'sentaku'});"]
[eval exp="tyrano.plugin.kag.tmp_patterns_himitsu.push({word:'選ぶ', replies:['君は誰かに私を助けるか助けないかを選択しろって言われてるの？','君は私を助けるかどうかを決めろって言われてるの？'], feeling:'neutral', result:'sentaku'});"]
[eval exp="tyrano.plugin.kag.tmp_patterns_himitsu.push({word:'選べ', replies:['君は誰かに私を助けるか助けないかを選択しろって言われてるの？','君は私を助けるかどうかを決めろって言われてるの？'], feeling:'neutral', result:'sentaku'});"]
[eval exp="tyrano.plugin.kag.tmp_patterns_himitsu.push({word:'無為', replies:['何を言っているの？　私は天音亜音だよ……','え？　違うよ。私は天音亜音だよ？'], feeling:'sad', result:'mio'});"]
[eval exp="tyrano.plugin.kag.tmp_patterns_himitsu.push({word:'澪', replies:['何を言っているの？　私は天音亜音だよ……','え？　違うよ。私は天音亜音だよ？'], feeling:'sad', result:'mio'});"]
[eval exp="tyrano.plugin.kag.tmp_patterns_himitsu.push({word:'無為澪', replies:['何を言っているの？　私は天音亜音だよ……','え？　違うよ。私は天音亜音だよ？'], feeling:'sad', result:'mio'});"]
; セーブ対応変数に格納
[eval exp="sf.patterns_himitsu=tyrano.plugin.kag.tmp_patterns_himitsu;"]
[endmacro]
; ---秘密マッチングマクロ ---
[macro name="match_himitsu_patterns"]
[eval exp="sf.matched=false;var patterns=sf.patterns_himitsu;for(var i=0;i<patterns.length;i++){if(sf.input.indexOf(patterns[i].word)!=-1){var replies=patterns[i].replies;var index=Math.floor(Math.random()*replies.length);sf.reply=replies[index];sf.feeling=patterns[i].feeling;sf.result=patterns[i].result;sf.matched=true;if(sf.feeling=='positive'||sf.feeling=='relieved'){sf.shinmitsudo+=1;}if(sf.feeling=='bewildered'){sf.shinmitsudo-=1;}break;}}if(!sf.matched){sf.reply='';sf.feeling='none';sf.result='unknown';sf.matched=true;}"]
[endmacro]